% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mod_filenames.R
\name{get_mod_filenames}
\alias{get_mod_filenames}
\title{Find the names of MODIS images corresponding to the selected dates}
\usage{
get_mod_filenames(
  http,
  used_server,
  user,
  password,
  n_retries,
  date_dir,
  v,
  h,
  tiled,
  out_folder_mod,
  gui
)
}
\arguments{
\item{http}{\code{character} url of http site on lpdaac corresponding to a given MODIS
product.}

\item{used_server}{\code{character} can assume values "http"; it cannot be NA.}

\item{user}{\code{character} username for earthdata server.}

\item{password}{\code{character} password for earthdata server.}

\item{n_retries}{\code{numeric} number of times the access to the http server
should be retried in case of error before quitting, Default: 20.}

\item{date_dir}{\verb{character array} array of folder names corresponding to acquisition
containing dates where MODIS files to be downloaded are to be identified
(return array from \code{get_mod_dates}).}

\item{v}{\verb{integer array} containing a sequence of the vertical tiles of interest
(e.g., c(18,19)).}

\item{h}{\verb{integer array} containing a sequence of the horizontal tiles of interest
(e.g., c(3,4)).}

\item{tiled}{\code{numeric [0/1]} indicates if the product to be downloaded is
tiled or not tiled. 1 = tiled product; 0 = non-tiled product (resolution 0.05 deg).}

\item{out_folder_mod}{\code{character} folder where hdf files have to be stored.}

\item{gui}{\code{logical} indicates if processing was called within the GUI environment
or not. If not, processing messages are redirected direct to the log file.}
}
\value{
\verb{character array} containing names of HDF images corresponding to the
requested tiles available for the product in the selected date
}
\description{
Accessory function to find the names of HDF images corresponding
to a given date and interval of spatial tiles within the lpdaac archive.
}
\note{
License: GPL 3.0
}
\author{
Original code by Babak Naimi (\code{.getModisList}, in
\href{http://r-gis.net/?q=ModisDownload}{ModisDownload.R})
modified to adapt it to MODIStsp scheme and to http archive (instead than old
FTP) by:

Lorenzo Busetto, phD (2014-2016) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2016) \email{ranghetti.l@irea.cnr.it}
}
