% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_vrt_create.R
\name{MODIStsp_vrt_create}
\alias{MODIStsp_vrt_create}
\title{Create MODIStsp virtual files}
\usage{
MODIStsp_vrt_create(
  sensor,
  out_prod_folder,
  bandnames,
  bandsel,
  nodata_out,
  indexes_bandnames,
  indexes_bandsel,
  indexes_nodata_out,
  quality_bandnames,
  quality_bandsel,
  quality_nodata_out,
  file_prefixes,
  ts_format,
  out_format,
  verbose
)
}
\arguments{
\item{sensor}{\code{character ["Terra"| "Aqua" | "Both"]} MODIS platform to be considered.
(Ignored for MCD* products). Default: "Both"}

\item{out_prod_folder}{\code{character} Main output folder.}

\item{bandnames}{names of all layers available for the product being processed}

\item{bandsel}{\verb{character array} Original MODIS layers to be processed.
You can get a list of available layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$bandnames),
Default: NULL}

\item{nodata_out}{\code{numeric} Output nodata value to be used in vrt files}

\item{indexes_bandnames}{names of all indexes available for the product being processed}

\item{indexes_bandsel}{\verb{character array}Spectral Indexes to be computed starting from reflectance bands.
You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$indexes_bandnames),
Default: NULL}

\item{indexes_nodata_out}{nodata value for indexes vrts}

\item{quality_bandnames}{names of all quality indicators available for the product being processed}

\item{quality_bandsel}{\verb{character array} Quality Indicators to be computed starting from
bit fields of original MODIS layers. You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$quality_bandnames),
Default: NULL}

\item{quality_nodata_out}{nodata value for quality vrts}

\item{file_prefixes}{\verb{character array (2)} file_prefixes for TERRA and AQUA -
used to identify the files corresponding to each sensor}

\item{ts_format}{\code{character ["ENVI" | "GDAL" | "Both"]} Required output format
for virtual file.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Format of images used as
"input" for the vrt and contained in out_prod_folder/band folders.}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
NULL - the function is called for its side effects
}
\description{
Function used to create virtual files from time series of single-band
files corresponding to different acquisition dates. The function takes as input
the folder in which the single-band files are stored, and creates a ENVI Meta
file and/or a GDAL vrt file that allows access to the full time series as if
it was a single physical file.
Created virtual files are stored in the "Time Series" subfolder of `out_prod_folder``
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2017)

Luigi Ranghetti, phD (2015)
}
