% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition_msld.R
\name{decomposition_msld}
\alias{decomposition_msld}
\title{Problem Decomposition using Multi-layered Simplex-lattice Design}
\usage{
decomposition_msld(decomp, ...)
}
\arguments{
\item{decomp}{list containing the relevant decomposition parameters.
Besides \code{decomp$name = "msld"}, this method requires the definition of the
following key-value pairs in \code{decomp}:

\itemize{
\item \code{decomp$H}: array of positive integers representing the
\code{H} values to be used by the SLD decomposition
at each layer (see \code{\link[=decomposition_sld]{decomposition_sld()}} for
details).
\item \code{decomp$tau}: array of scale multipliers for each layer,
\eqn{0 < \tau_i \le 1}, \eqn{\tau_i != \tau_j} for all \eqn{i != j}.
Must have the same lenght as \code{decomp$H}.
\item \code{decomp$.nobj}: integer value, \code{decomp$.nobj > 1}. Number of
objectives of the problem.
}}

\item{...}{other parameters (included for compatibility with generic call)}
}
\description{
Problem Decomposition using Multi-layered Simplex-lattice Design for MOEADr
package
}
\details{
This routine calculates the weight vectors for the MOEA/D using the
Multi-layered Simplex-lattice Design.
}
\section{References}{

K. Li et al. (2014), "An Evolutionary Many-Objective Optimization
Algorithm Based on Dominance and Decomposition",
IEEE Trans. Evol. Comp. 19(5):694-716, 2015. DOI: 10.1109/TEVC.2014.2373386
}

