% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.single.t.R
\name{d.single.t}
\alias{d.single.t}
\title{d for Single t from Means}
\usage{
d.single.t(m, u, sd, n, a = 0.05)
}
\arguments{
\item{m}{sample mean}

\item{u}{population mean}

\item{sd}{sample standard deviation}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{m}{sample mean}
\item{sd}{standard deviation of the sample}
\item{se}{standard error of the sample}
\item{Mlow}{lower level confidence interval of the sample mean}
\item{Mhigh}{upper level confidence interval of the sample mean}
\item{u}{population mean}
\item{n}{sample size}
\item{df}{degrees of freedom (n - 1)}
\item{t}{t-statistic}
\item{p}{p-value}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays d and non-central confidence interval for single t from means.
}
\details{
To calculate d, the population is subtracted from the sample mean,
which is then divided by the standard deviation.

d = (m - u) / sd

\href{https://www.aggieerin.com/shiny-server/tests/singletm.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "singt_data" dataset included
#in the MOTE library.

#A school has a gifted/honors program that they claim is
#significantly better than others in the country. The gifted/honors
#students in this school scored an average of 1370 on the SAT,
#with a standard deviation of 112.7, while the national average
#for gifted programs is a SAT score of 1080.

    gift = t.test(singt_data, mu = 1080, alternative = "two.sided")

#You can type in the numbers directly as shown below,
#or refer to your dataset within the function.

    d.single.t(m = 1370, u = 1080, sd = 112.7, n = 14, a = .05)

    d.single.t(1370, 1080, 112.7, 100, .05)

    d.single.t(gift$estimate, gift$null.value,
            sd(singt_data$SATscore),
        length(singt_data$SATscore), .05)
}
\keyword{effect}
\keyword{mean}
\keyword{mean,}
\keyword{mu,}
\keyword{population}
\keyword{sample}
\keyword{single}
\keyword{single-sample,}
\keyword{size,}
\keyword{t,}
\keyword{u,}
