% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot2D.R
\name{plot2D}
\alias{plot2D}
\title{Plot regions of the representative tree in 2D}
\usage{
plot2D(ans, type = "prob", data.points = "all", background = "none",
  group = 1, dim = c(1, 2),
  levels = sort(unique(ans$RepresentativeTree$Levels)), regions = rep(1,
  length(ans$RepresentativeTree$Levels)), legend = FALSE, main = "default")
}
\arguments{
\item{ans}{An \code{mrs} object.}

\item{type}{Different options on how to visualize the rectangular regions.
The options are \code{type = c("eff", "prob", "empty", "none")}.
Default is \code{type = "prob"}.}

\item{data.points}{Different options on how to plot the data points.
The options are \code{data.points = c("all", "differential", "none")}.
Default is \code{data.points = "all"}.}

\item{background}{Different options on the background.
The options are \code{background = c("smeared", "none") }.}

\item{group}{If \code{type = "eff"}, which group effect size is used.
Default is \code{group = 1}.}

\item{dim}{If the data are multivariate,
\code{dim} are the two dimensions plotted. Default is \code{dim = c(1,2)}.}

\item{levels}{Vector with the level of the regions to plot.
The default is to plot regions at all levels.}

\item{regions}{Binary vector indicating the regions to plot.
The default is to plot all regions.}

\item{legend}{Color legend for type. Default is \code{legend = FALSE}.}

\item{main}{Overall title for the legend.}
}
\description{
This function visualizes the regions of the representative tree
of the output of the \code{\link{mrs}} function.
}
\examples{
set.seed(1)
p = 2
n1 = 200
n2 = 200
mu1 = matrix( c(9,9,0,4,-2,-10,3,6,6,-10), nrow = 5, byrow=TRUE)
mu2 = mu1; mu2[2,] = mu1[2,] + 1

Z1 = sample(5, n1, replace=TRUE)
Z2 = sample(5, n2, replace=TRUE)
X1 = mu1[Z1,] + matrix(rnorm(n1*p), ncol=p)
X2 = mu2[Z2,] + matrix(rnorm(n2*p), ncol=p)
X = rbind(X1, X2)
colnames(X) = c(1,2)
G = c(rep(1, n1), rep(2,n2))

ans = mrs(X, G, K=8)
plot2D(ans, type = "prob", legend = TRUE)

plot2D(ans, type="empty", data.points = "differential",
 background = "none")

plot2D(ans, type="none", data.points = "differential",
 background = "smeared", levels = 4)
}
\references{
Soriano J. and Ma L. (2014). Multi-resolution two-sample comparison
through the divide-merge Markov tree. \emph{Preprint}.
 \url{http://arxiv.org/abs/1404.3753}
}

