% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{quartetTallyCpp}
\alias{quartetTallyCpp}
\title{Build quartet table from distances}
\usage{
quartetTallyCpp(dList, M, nt, Q, random, progressbar = FALSE)
}
\arguments{
\item{dList}{a list of distance matrices}

\item{M}{number of sets of 4 taxa}

\item{nt}{number of gene trees/distance matrices}

\item{Q}{matrix to fill out as table of quartet counts}

\item{random}{if 0 compute for all sets of 4 taxa, otherwise for M random ones}

\item{progressbar}{if TRUE, display progress bar}
}
\value{
Q with quartet counts filled in, and a flag indicating whether any
taxa were missing
}
\description{
This is a C++ function, called from quartetTable, to fill in the quartet counts.
From a list of topological distance matrices (1 for each gene tree) it determines all
gene quartets. The faster looping in C++ gives substantial time improvements
over R code. Doucumentation if for internal use only.
}
\seealso{
\code{\link{quartetTable}}, \code{\link{quartetTableParallel}}
}
