% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_AM.R
\name{prelim_AM}
\alias{prelim_AM}
\title{Preliminary Assessments in MSE}
\usage{
prelim_AM(x, Assess, ncpus = 1, ...)
}
\arguments{
\item{x}{Either a \code{Hist}, \code{Data} or \code{OM} object.}

\item{Assess}{An Assess function of class \code{Assess}.}

\item{ncpus}{Numeric, the number of CPUs to run the Assessment model (will run in parallel if greater than 1).}

\item{...}{Arguments to be passed to \code{Assess}, e.g., model configurations.}
}
\value{
Returns invisibly a list of \linkS4class{Assessment} objects of length \code{OM@nsim}. Messages via console.
}
\description{
Evaluates the likely performance of Assessment models in the operating model. This function will
apply the assessment model for Data generated during the historical period of the MSE, and report
the convergence rate for the model and total time elapsed in running the assessments.
}
\examples{
\dontrun{
prelim_AM(DLMtool::testOM, DD_TMB)
}
}
\author{
Q. Huynh
}
