% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrospective_AM.R
\name{retrospective_AM}
\alias{retrospective_AM}
\title{retrospective_AM (retrospective of Assessment model in MSE)}
\usage{
retrospective_AM(MSE, sim = 1, MP, MSE_Hist = NULL,
  plot_legend = FALSE)
}
\arguments{
\item{MSE}{An object of class MSE created by \code{\link[DLMtool]{runMSE}} with \code{PPD = TRUE}.}

\item{sim}{Integer between 1 and MSE@nsim. The simulation number for which the retrospectives will be plotted.}

\item{MP}{Character. The name of the management procedure created by \code{\link{make_MP}} containing the asssessment model.}

\item{MSE_Hist}{Optional. The list containing historical data for the MSE, created by \code{\link[DLMtool]{runMSE}} with argument \code{Hist = TRUE}.
Currently only used to plot operating model vulnerable biomass in historical period.}

\item{plot_legend}{Logical. Whether to plot legend to reference year of assessment in the MSE.}
}
\value{
A series of figures for spawning stock biomass
(SSB, including absolute magnitude and relative to MSY and virgin), fishing mortality (F, including absolute
magnitude and relative to MSY), and vulnerable biomass (VB) estimates over the course of the MSE are plotted
against the operating model (true) values (in black).
}
\description{
Plots the true retrospective of an assessment model during the MSE. A series of time series estimates of SSB, F, and VB
are plotted over the course of the MSE are plotted against the operating model (true) values (in black).
}
\details{
For assessment models that utilize annual harvest rates (u), the instantaneous fishing mortality rates
are obtained as F = -log(1 - u).
}
\note{
This function only plots retrospectives from a single simulation in the MSE. Results from one figure
may not be indicative of general assessment behavior and performance overall.

For \link{SP} and \link{SP_SS} assessment models don't model SSB. Instead, the estimated vulnerable biomass is plotted.
}
\examples{
\dontrun{
DD_MSY <- makeMP(DD_TMB, HCR_MSY, diagnostic = "full")
myMSE_hist <- DLMtool::runMSE(DLMtool::testOM, Hist = TRUE)
myMSE <- DLMtool::runMSE(DLMtool::testOM, MPs = "DD_MSY", PPD = TRUE)
retrospective_AM(myMSE, sim = 1, MP = "DD_MSY")
retrospective_AM(myMSE, sim = 1, MP = "DD_MSY", Hist = myMSE_hist)
}
}
\seealso{
\link{diagnostic_AM}
}
\author{
Q. Huynh
}
