% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ancillary_Indicators.R
\name{getinds}
\alias{getinds}
\title{Characterize posterior predictive data}
\usage{
getinds(
  PPD,
  styr,
  res = 6,
  tsd = c("Cat", "Cat", "Cat", "Ind", "ML"),
  stat = c("slp", "AAV", "mu", "slp", "slp")
)
}
\arguments{
\item{PPD}{An object of class Data stored in the Misc slot of an MSE object following a call of \code{runMSE(PPD = TRUE)}.}

\item{styr}{Positive integer, the starting year for calculation of quantities}

\item{res}{Positive integer, the temporal resolution (chunks - normally years) over which to calculate quantities}

\item{tsd}{Character vector of names of types of data: Cat = catch, Ind = relative abundance index, ML = mean length in catches}

\item{stat}{Character vector of types of quantity to be calculated: slp = slope(log(x)), AAV = average annual variability, mu = mean(log(x))}
}
\value{
A 3D array of results (type of data/stat (e.g. mean catches),time period (chunk), simulation)
}
\description{
Characterize posterior predictive data
}
\references{
Carruthers and Hordyk 2018
}
\author{
T. Carruthers
}
