% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simahead.R
\name{simahead}
\alias{simahead}
\title{Step ahead simulation method.}
\usage{
simahead(object, n, m, theta, y)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{n}{Mumber of step ahead time step. (Default: \code{n = 1})}

\item{m}{Number of simulations. (Default: m = 1)}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates (not require when using a fit object).}

\item{y}{Vector (of size T) of observations (not require when using a fit object).}
}
\value{
A list of class \code{MSGARCH_SIM} containing  two components:
\itemize{
\item \code{draws}:  Matrix (of size m x n) of step ahead simulated draws.
\item \code{state}:  Matrix (of size m x n) of step ahead simulated states.
}
The \code{MSGARCH_SIM} class contains the \code{plot} method.
}
\description{
Method returning step ahead simulation up to time \code{n}.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually and \code{m = M}.
The \code{MSGARCH_SIM} class contains the \code{plot} method. The difference between \code{\link{sim}} and \code{\link{simahead}} is that
\code{\link{sim}} starts the simulation a t = 0 creating an entire new process while  \code{\link{simahead}} starts the simulation at t = T + 1
 taking in consideration all the information available in the original time serie \code{y}.
}
\examples{
\dontrun{
# load data
data("sp500")

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500)
 
# generate random draws
set.seed(123)
simahead = MSGARCH::simahead(object = fit, n = 30, m = 1000)

plot(simahead)
}
}

