\name{createTimeVaryingCovariates}
\alias{createTimeVaryingCovariates}
\title{ Create a set of time-varying covariates  }
\description{
  Creates a set of time-varying covariates from a multivariate normal
 distribution and (optionally) a set of constraints.
}
\usage{
createTimeVaryingCovariates(subjects, names, mean, covariance = 0, range = NULL, digits, 
  maxDraws = 100, seed = .deriveFromMasterSeed(), idCol = getEctdColName("Subject"), 
  timeCol = getEctdColName("Time"), treatPeriod)

}
\arguments{
  \item{subjects}{ (Required) Subjects for which to create covariates                         }
  \item{names}{ (Required) Names for the continuous covariates.  They should be valid R names (See \code{\link{validNames}}) and no duplicate name should be given }
  \item{mean}{ (Required) List of means. Must be of same length than \code{names}. If it is a vector, all the time point will use the same value }
  \item{covariance}{ (Optional) Lower triangle of covariance matrix. See \code{\link{parseCovMatrix}} for details.  Should be a list. If it is a vector, all the time point will use the same value}
  \item{range}{ (Optional) Ranges of acceptable values for each covariates. See \code{\link{parseRangeCode}} for details.  It should be a list. If some covariates don't have the range, the components should be set to NULL}
  \item{digits}{ (Optional) Number of digits used to round the values.  This argument can be either missing (the default), so no rounding is done, of length one and all variables are rounded at the same digits, of same length than the number of covariates so that each covariate is rounded according to its value. This argument is first parsed by \code{\link{parseCharInput}} so it can either be a character vector or a numeric vector. See \code{\link{parseCharInput}}.  If the parsed \code{digits} vector does not have length one or length equal to the number of covariates, an error is generated by the \code{\link{ectdStop}} function.  This is missing by default, resulting in no rounding being performed }
  \item{maxDraws}{ (Optional) Maximum number of attempts allowed if initial data not in range (100 by default) } 
  \item{seed}{ (Optional) Random seed to use.  By default, this is derived from the current random seed } 
  \item{idCol}{ (Optional) Name of the subject column. Must be a valid R name (See \code{\link{validNames}}) and not equal to one entry of \code{names}.  "SUBJ" by default }
  \item{timeCol}{ (Optional) Name of the time column. Must be a valid R name (See \code{\link{validNames}}) and not equal to one entry of \code{names}.  "TIME" by default }
  \item{treatPeriod}{Vector of time points}
}
\author{ Mike K Smith \email{mstoolkit@googlemail.com} }
\seealso{ 
\code{\link{createDiscreteCovariates}} to create covariates for a discrete distribution.

\code{\link{createExternalCovariates}} to create covariates by \emph{sampling} 
data from an external file.

\code{\link{createCovariates}} that wraps \code{createContinuousCovariates} and the 
two other described above.
}                       

\examples{

  # same   
  dat <- createTimeVaryingCovariates(10, "X, Y, Z", 
	mean <- list(X = 1:4, Y = rep(3, 4), Z = "2.5, 3, 3.2, 3.6"),
	covariance = list(1, 2:5, cbind(c(1,.5,.3,0), c(.5,1,0,0), c(.3,0,1,0), c(0,0,0,1))),
	range = list("10>=X>0", NULL, c("Z>0", "Z<=10")),
	idCol = "SUBJ", timeCol = "TIME", treatPeriod = c(0.25, 0.5, 1, 12))

}
\keyword{ datagen }

