% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{predict.mtlr}
\alias{predict.mtlr}
\title{Predictions for MTLR}
\usage{
\method{predict}{mtlr}(object, newdata, type = c("survivalcurve",
  "prob_event", "mean_time", "median_time"), add_zero = T, ...)
}
\arguments{
\item{object}{an object of class mtlr, generated by the \link[MTLR]{mtlr}.}

\item{newdata}{an optional new dataframe for which to perform predictions using MTLR. If left empty, predictions will
be performed using the dataset used to generate the original mtlr object -- note that any error calculation on these
predictions will be optimistic since this will only be the resubstitution error and not be representative of error on a new test set.}

\item{type}{the type of prediction desired. Options are the survival curve "survivalcurve", the probability of survival at the
observations event time "prob_event", the mean survival time "mean_time", and the median survival time, "median_time".
For "survivalcurve", the first column of the matrix returned will correspond to the time points and all other columns will be
the observations survival probability at those associated time points. The index of a (row) observation in newdata will correspond
to the \emph{ith + 1} column of the returned matrix.
If "prob_event" is chosen the response (event time) is required. For "mean_time", if survival curves do not extend to zero survival
probability a linear extension is added (a linear line from (time = 0,probability = 1) to (time = ?, probability =0)). This is the
same for "median_time" except the line need only extend to survival probability = 0.5.
A mean/median survival time of Inf is returned for survival curves with all survival probabilities of 1.}

\item{add_zero}{if TRUE, a time point of "0" and a survival probability of "1" will be added to all survival curves. Additionally,
if add_zero is TRUE, type = "mean_time" will represent the average survival time overall but if FALSE, then "mean_time" will be reduced
by roughly the value of the first time point. However, "median_time" and "prob_event" will be unchanged.}

\item{...}{for future methods.}
}
\value{
The desired prediction type (a matrix or vector of predictions).
}
\description{
Compute survival curves and other fitted values for a model generated by \code{\link[MTLR]{mtlr}}.
}
\note{
The predictions generated by type = "survivalcurve" can be plotted using \code{\link[MTLR]{plotcurves}} -- packages
ggplot2 and reshape2  must be installed to use this function.
}
\examples{
library(survival)
mod <- mtlr(Surv(time,status)~., data = lung)

#Here our predictions are on the data from which we trained so our results will be optimistic
# since they are produced from resubstitution as opposed to some new test set.
predict(mod, type = "survivalcurve")
predict(mod, type = "prob_event")
predict(mod, type = "median_time")
predict(mod, type = "mean_time")

#Notice the difference of about 59:
predict(mod, type = "mean_time", add_zero = FALSE)
}
\seealso{
\code{\link[MTLR]{mtlr}} \code{\link[MTLR]{plotcurves}}
}
