% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{bmizs}
\alias{bmizs}
\title{Generate Body Mass Index z-scores for age  and percentiles for children/adolescents given their age, sex, and bmi values.}
\usage{
bmizs(Datafm, age_range = "0-24", Notes = FALSE)
}
\arguments{
\item{Datafm}{A DataFrame with variables age (in months), sex (1, 2 or "Male", "Female"),
bmi (numeric: in kilograms per meter squared (kg/m^2)).}

\item{age_range}{age range in months. Input has to be characters.
It allows "0-24" by default. Other inputs allowed are "24-60" or "61-228".}

\item{Notes}{Is FALSE by default. If set to TRUE, 'notes' will be printed on the console about the nature,
range of variables allowed and number of records processed.}
}
\value{
A DataFrame with BMI z scores for age and percentiles.
}
\description{
Generates Body Mass Index (BMI) for age z-scores and percentiles based on LMS method for children and
adolescents aged 0 to 19 years.
}
\examples{
## Example 1: for younger age range = "0-24" months
## No need to specify age_range
## creating a hypothetical dataset

dat1 <- data.frame(age = c(5, 6, 12, 12, 18, 18, 23, 23),
        sex = c(1, 2, 1, 2, 1, 2, 1, 2),
        bmi = c(17.3, 18.6, 18.2, 12.7, 20.8, 20.8, 13.6, 18.4))

ans1 <- bmizs(Datafm = dat1)
ans1 <- bmizs(Datafm = dat1, Notes = TRUE) # Will also print notes
# ans1

## Example 2: specify age range = "24-60" months
## creating a hypothetical dataset

dat2 <- data.frame(age = c(25, 36, 48, 60),
        sex = 2, bmi = c(15.7, 16.8, 20.6, 12.7))

ans2 <- bmizs(Datafm = dat2, age_range = "24-60")
# ans2

## Example 3: specify age range = "61-228" months
## creating a hypothetical dataset

dat3 <- data.frame(age = c(61, 73, 181, 217),
        sex = 1, bmi = c(12.1, 14.1, 27.1, 35.4))

ans3 <- bmizs(Datafm = dat3, age_range = "61-228")
# ans3

}
\references{
<https://www.who.int/childgrowth/standards/bmi_for_age/en/>

<https://www.who.int/growthref/who2007_bmi_for_age/en/>

<https://www.who.int/childgrowth/standards/Technical_report.pdf>
}
\seealso{
\code{\link{indivmuaczs}}, \code{\link{muaczs}}, \code{\link{muacz.bmiz}}, \code{\link{plotmuac}} and \code{\link{plotbmi}}.
}
