% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimentDesign.R
\name{experimentDesign}
\alias{experimentDesign}
\title{Step3: Generate the experimental design matrix.}
\usage{
experimentDesign(data, Step = 1, random = FALSE)
}
\arguments{
\item{data}{A data frame that has been processed through the 'loadData' function, containing the experimental items and their attributes.}

\item{Step}{An integer indicating how many sessions (the whole set of trials) should be run. Default is 1, meaning no repetition.}

\item{random}{A logical indicating whether the trials should be randomized. Default is FALSE, meaning trials will occur in the order provided.}
}
\value{
A data.frame with the designed structure for the experiment, including any repetitions and randomizations as specified. Each row corresponds to a single trial or instance in the experiment.
}
\description{
Defines the experiment setup based on the stimuli loaded.
}
\examples{

df <- data.frame(
Run = c(1,2),
Item = c(1,2),
Condition = c(1,2),
TargetPrompt = c("1","2")
)

ExperimentItem=loadData(df$Run,df$Item,df$Condition,promptList = df$TargetPrompt)

Design=experimentDesign(ExperimentItem,Step=1,random = TRUE)

}
