% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_QDAModel.R
\name{QDAModel}
\alias{QDAModel}
\title{Quadratic Discriminant Analysis Model}
\usage{
QDAModel(prior = NULL, method = c("moment", "mle", "mve", "t"),
  nu = 5, use = c("plug-in", "predictive", "debiased", "looCV"))
}
\arguments{
\item{prior}{prior probabilities of class membership if specified or the
class proportions in the training set otherwise.}

\item{method}{type of mean and variance estimator.}

\item{nu}{degrees of freedom for \code{method = "t"}.}

\item{use}{type of parameter estimation to use for prediction.}
}
\value{
MLModel class object.
}
\description{
Performs quadratic discriminant analysis.
}
\details{
\describe{
\item{Response Types:}{\code{factor}}
}

The \code{\link{predict}} function for this model additionally accepts the
following argument.
\describe{
\item{\code{prior}}{prior class membership probabilities for prediction data
if different from the training set.}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
fit(Species ~ ., data = iris, model = QDAModel())

}
\seealso{
\code{\link[MASS]{qda}}, \code{\link[MASS]{predict.qda}},
\code{\link{fit}}, \code{\link{resample}}, \code{\link{tune}}
}
