% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_StackedModel.R
\name{StackedModel}
\alias{StackedModel}
\title{Stacked Regression Model}
\usage{
StackedModel(..., control = CVControl, weights = NULL)
}
\arguments{
\item{...}{MLModel objects to serve as base learners.}

\item{control}{\code{\linkS4class{MLControl}} object, control function, or
character string naming a control function defining the resampling method to
be employed for the estimation of base learner weights.}

\item{weights}{optional fixed base learner weights.}
}
\value{
StackedModel class object that inherits from MLModel.
}
\description{
Fit a stacked regression model from multiple base learners.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}, \code{ordered},
\code{Surv}
}
}
}
\examples{
library(MASS)

model <- StackedModel(GBMModel, SVMRadialModel, GLMNetModel(lambda = 0.01))
modelfit <- fit(medv ~ ., data = Boston, model = model)
predict(modelfit, newdata = Boston)

}
\references{
Breiman, L. (1996) \emph{Stacked Regression.} Machine Learning, 24, 49--64.
}
\seealso{
\code{\link{fit}}, \code{\link{resample}}, \code{\link{tune}}
}
