% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_CoxModel.R
\name{CoxModel}
\alias{CoxModel}
\alias{CoxStepAICModel}
\title{Proportional Hazards Regression Model}
\usage{
CoxModel(ties = c("efron", "breslow", "exact"), ...)

CoxStepAICModel(
  ties = c("efron", "breslow", "exact"),
  ...,
  direction = c("both", "backward", "forward"),
  scope = NULL,
  k = 2,
  trace = FALSE,
  steps = 1000
)
}
\arguments{
\item{ties}{character string specifying the method for tie handling.}

\item{...}{arguments passed to \code{\link[survival]{coxph.control}}.}

\item{direction}{mode of stepwise search, can be one of \code{"both"}
(default), \code{"backward"}, or \code{"forward"}.}

\item{scope}{defines the range of models examined in the stepwise search.
This should be a list containing components \code{upper} and \code{lower},
both formulae.}

\item{k}{multiple of the number of degrees of freedom used for the penalty.
Only \code{k = 2} gives the genuine AIC; \code{k = .(log(nobs))} is
sometimes referred to as BIC or SBC.}

\item{trace}{if positive, information is printed during the running of
\code{stepAIC}. Larger values may give more information on the fitting
process.}

\item{steps}{maximum number of steps to be considered.}
}
\description{
Fits a Cox proportional hazards regression model. Time dependent variables,
time dependent strata, multiple events per subject, and other extensions are
incorporated using the counting process formulation of Andersen and Gill.
}
\details{
\describe{
  \item{Response Types:}{\code{Surv}}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.

In calls to \code{\link{varimp}} for \code{CoxModel} and
\code{CoxStepAICModel}, numeric argument \code{base} may be specified for the
(negative) logarithmic transformation of p-values [defaul: \code{exp(1)}].
Transformed p-values are automatically scaled in the calculation of variable
importance to range from 0 to 100.  To obtain unscaled importance values, set
\code{scale = FALSE}.

#' @return \code{MLModel} class object.
}
\examples{
library(survival)
library(MASS)

fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
    data = Melanoma, model = CoxModel)

}
\seealso{
\code{\link[survival]{coxph}},
\code{\link[survival]{coxph.control}}, \code{\link[MASS]{stepAIC}},
\code{\link{fit}}, \code{\link{resample}}
}
