% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_lincomp.R
\name{step_lincomp}
\alias{step_lincomp}
\alias{tidy.step_lincomp}
\alias{tunable.step_lincomp}
\title{Linear Components Variable Reduction}
\usage{
step_lincomp(
  recipe,
  ...,
  transform,
  num_comp = 5,
  options = list(),
  center = TRUE,
  scale = TRUE,
  replace = TRUE,
  prefix = "LinComp",
  role = "predictor",
  skip = FALSE,
  id = recipes::rand_id("lincomp")
)

\method{tidy}{step_lincomp}(x, ...)

tunable.step_lincomp(x, ...)
}
\arguments{
\item{recipe}{\link[recipes]{recipe} object to which the step will be added.}

\item{...}{one or more selector functions to choose which variables will be
used to compute the components.  See \code{\link[recipes]{selections}} for
more details.  These are not currently used by the \code{tidy} method.}

\item{transform}{function whose first argument \code{x} is a matrix of
variables with which to compute linear combinations and second argument
\code{step} is the current step.  The function should return a
transformation \code{\link{matrix}} or \code{\link[Matrix]{Matrix}} of
variable weights in its columns, or return a list with element
\code{`weights`} containing the transformation matrix and possibly with
other elements to be included as attributes in output from the \code{tidy}
method.}

\item{num_comp}{number of components to derive.  The value of \code{num_comp}
will be constrained to a minimum of 1 and maximum of the number of original
variables when \code{\link[recipes]{prep}} is run.}

\item{options}{list of elements to be added to the step object for use in the
\code{transform} function.}

\item{center, scale}{logicals indicating whether to mean center and standard
deviation scale the original variables prior to deriving components, or
functions or names of functions for the centering and scaling.}

\item{replace}{logical indicating whether to replace the original variables.}

\item{prefix}{character string prefix added to a sequence of zero-padded
integers to generate names for the resulting new variables.}

\item{role}{analysis role that added step variables should be assigned.  By
default, they are designated as model predictors.}

\item{skip}{logical indicating whether to skip the step when the recipe is
baked.  While all operations are baked when \code{\link[recipes]{prep}} is
run, some operations may not be applicable to new data (e.g. processing
outcome variables).  Care should be taken when using \code{skip = TRUE} as
it may affect the computations for subsequent operations.}

\item{id}{unique character string to identify the step.}

\item{x}{\code{step_lincomp} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).  For the \code{tidy} method, a tibble
with columns \code{terms} (selectors or variables selected), \code{weight}
of each variable in the linear transformations, and \code{name} of the new
variable names.
}
\description{
Creates a \emph{specification} of a recipe step that will compute one or more
linear combinations of a set of numeric variables according to a
user-specified transformation matrix.
}
\examples{
library(recipes)

pca_mat <- function(x, step) {
  prcomp(x)$rotation[, 1:step$num_comp, drop = FALSE]
}

rec <- recipe(rating ~ ., data = attitude)
lincomp_rec <- rec \%>\%
  step_lincomp(all_numeric(), -all_outcomes(),
               transform = pca_mat, num_comp = 3, prefix = "PCA")

lincomp_prep <- prep(lincomp_rec, training = attitude)
lincomp_data <- bake(lincomp_prep, attitude)

pairs(lincomp_data, lower.panel = NULL)

tidy(lincomp_rec, number = 1)
tidy(lincomp_prep, number = 1)

}
\seealso{
\code{\link[recipes]{recipe}}, \code{\link[recipes]{prep}},
\code{\link[recipes]{bake}}
}
