% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em-magma.R
\name{e_step}
\alias{e_step}
\title{E-Step of the EM algorithm}
\usage{
e_step(db, m_0, kern_0, kern_i, hp_0, hp_i, pen_diag)
}
\arguments{
\item{db}{A tibble or data frame. Columns required: ID, Input, Output.
Additional columns for covariates can be specified.}

\item{m_0}{A vector, corresponding to the prior mean of the mean GP.}

\item{kern_0}{A kernel function, associated with the mean GP.}

\item{kern_i}{A kernel function, associated with the individual GPs.}

\item{hp_0}{A named vector, tibble or data frame of hyper-parameters
associated with \code{kern_0}.}

\item{hp_i}{A tibble or data frame of hyper-parameters
associated with \code{kern_i}.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
A named list, containing the elements \code{mean}, a tibble
containing the Input and associated Output of the hyper-posterior's mean
parameter, and \code{cov}, the hyper-posterior's covariance matrix.
}
\description{
Expectation step of the EM algorithm to compute the parameters of the
hyper-posterior Gaussian distribution of the mean process in Magma.
}
\examples{
TRUE
}
