% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightitmice.data.R
\name{weightitmice.data}
\alias{weightitmice.data}
\title{Outputs Weighted Imputed Datasets}
\usage{
weightitmice.data(object, n = 1)
}
\arguments{
\item{object}{This argument specifies an object of the \code{wimids} class.}

\item{n}{This argument specifies the weighted imputed dataset number, intended to extract its data. The input must be a positive integer. The default is \code{1}.}
}
\value{
This function returns the imputed dataset sent to \code{weightitmice()} with weights of individuals of the datasets added (listed as the \code{inverse.weights} variables).
}
\description{
The \code{weightitmice.data()} function extracts data from an object of the \code{wimids} class.
}
\details{
The weighted datasets within the \code{wimids} class object are extracted.
}
\examples{
\donttest{
#Please see the package repository <https://github.com/FarhadPishgar/MatchIt.mice> for details.

#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the 'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(HANDOA ~ SEX + AGE, datasets)

#Extracting data of the first imputed dataset
data1 <- weightitmice.data(weighteddatasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
\keyword{functions}
