\name{neyman}

\alias{neyman}
\alias{print.neyman}

\title{Estimating treatment effects: Neyman's method}

\description{Calculates basic estimate of treatment effect, using simple difference in means and
Neyman's estimate of the variance.}

\details{Calculates overall treatment effect estimate using matched samples generated by
\code{matchit}.  If subclasses were generated in the matching procedure, the estimate is a
weighted average over the subclasses, with subclass weights defined by the \code{sub.by} option
in the \code{matchit} call.  The standard deviation can also be estimated using the bootstrap
procedure, which is often used when matching done with replacement.  For more details on the
calculations, see the complete documentation (link below).  The \code{summary} command on a
\code{neyman} object will provide a test of significance of the outcome as well as sample sizes
of the matched treated and control groups, and subclass estimates if applicable.  }

\usage{
neyman <- neyman(Y, object, bootstrap=NULL, counter=TRUE)
}

\arguments{ 
\item{Y}{(required).  Outcome variable of interest, included in \code{data} from
\code{matchit} object.} 
\item{object}{(required).  Stored output from \code{matchit}.}
\item{bootstrap}{Use the bootstrap to estimate standard errors (default=FALSE).  Often used when
matching done with replacement.} 
\item{counter}{Counter indicating progress of the bootstrap
(default=TRUE, which shows the counter).} 
}

\value{ 
\item{Returns estimate of the effect of the treatment, as well as the standard deviation
of that estimate.} }

\seealso{Please use \code{help.matchit} to access the matchit reference
  manual.  The complete document is available online at
  \url{http://gking.harvard.edu/matchit}.}

\author{
  Daniel Ho <\email{daniel.ho@yale.edu}>;  Kosuke Imai <\email{kimai@princeton.edu}>; Gary King
  <\email{king@harvard.edu}>; Elizabeth Stuart<\email{stuart@stat.harvard.edu}>
}

\keyword{htest}
