% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimids}
\alias{is.mimids}
\title{Checks for the \code{mimids} Class}
\usage{
is.mimids(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if is of the \code{mimids} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimids} class.
}
\description{
\code{is.mimids()} function checks whether class of objects is \code{mimids} or not.
}
\details{
The class of objects is checked to be of the \code{mimids}.
}
\examples{
\donttest{#Loading libraries
library(mice)
library(MatchThem)

#Loading the dataset
data(dataset)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg",
                                    "logreg", "logreg", "logreg"))

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                              approach = 'within', method = 'nearest')

#Checking the 'matched.datasets' object
is.mimids(matched.datasets)
is(matched.datasets)}
}
\seealso{
\code{\link[=matchthem]{matchthem}}

\code{\link[=mimids]{mimids}}
}
\author{
Farhad Pishgar
}
