\name{plotEstimates}
\alias{plotEstimates}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plot estimates along the frontier.
}
\description{
  \code{plotEstimates()} plots estimates along the frontier. 
}
\usage{
plotEstimates(estimates.object, xlab = "Number of Observations Pruned",
              ylab = "Estimate", main = "Effects Plot", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{estimates.object}{
    An object generated by \code{estimateEffects()}
  }
  \item{xlab}{
    The label for the x-axis. Defaults to 'Number of Observations Pruned'.
  }
  \item{ylab}{
    The label for the y-axis. Defaults to Estimate'.
  }
  \item{main}{
    The main label. Defaults to 'Effects Plot'.
  }
  \item{\dots}{
    Additional arguments to be passed to \code{plot}.
  }
}
\details{
  \code{plotEstimates()} wraps \code{plot} and uses \dots to
  pass additional arguments to the base \code{plot()} function,
  like color, axis range, etc. 
}
\examples{
data(lalonde)

# set seed for sampling a small data set for this example
set.seed(02139) 
lalonde <- lalonde[c(which(lalonde$treat == 1),
                     sample(which(lalonde$treat == 0), 500)), ]

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78', 'treat'))]
my.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)
my.estimates <- estimateEffects(my.frontier, 're78 ~ treat',
                                prop.estimated = .05)
plotEstimates(my.estimates)
}