\name{generateDataset}
\alias{generateDataset}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Generate a data set that is on the balance - sample size frontier.
}
\description{
  \code{generateDataset()} allows the user to export a data set
  that sits on the frontier.
}
\usage{
generateDataset(frontier.object, N)
}
\arguments{
  \item{frontier.object}{
    An object generated by \code{makeFrontier()}.	
  }
  \item{N}{
    The number of observations left in the exported data set.
    If the user selects an undefined point, \code{generateDataset}
    returns a dataset from the nearest defined point on the
    frontier.
  }
}
\examples{
data(lalonde)

match.on <- colnames(lalonde)[!(colnames(lalonde) \%in\% c('re78', 'treat'))]
my.frontier <- makeFrontier(dataset = lalonde,
                            treatment = 'treat',
                            outcome = 're78',
                            match.on = match.on)
n <- 300 # Identify the point from which to select the data
matched.data <- generateDataset(my.frontier, N = n)
}
\references{
  King, Gary, Christopher Lucas, and Richard
  Nielsen. "The Balance-Sample 
  Size Frontier in Matching Methods for Causal Inference." (2015).
}
