\name{MaxPro}
\alias{MaxPro}

\title{
Locally Optimal Maximum Projection Designs
}
\description{
Find the locally optimal maximum projection (MaxPro) design in the neighborhood of a given initial design
}
\usage{
MaxPro(InitialDesign,s=2,iteration=10)
}

\arguments{
  \item{InitialDesign}{
The initial design matrix, which we recommend to be a MaxPro Latin hypercube design generated by the \code{\link{MaxProLHD}} function
}
  \item{s}{
Optional, default is ``2''. The parameter in defining the s-norm distance (2 corresponds to Euclidean distance)
}
  \item{iteration}{
Optional, default is ``10''. The number of iterations in running the continuous local search
}
}

\details{
This function applies a continuous optimization algorithm in nloptr (Ypma 2014) to find the locally optimal MaxPro design in the neighborhood of the initial design. A MaxPro Latin hypercube design generated by the \code{\link{MaxProLHD}} function is a good choice for the initial design. Please refer to Joseph, Gul and Ba (2015) for details.
}

\value{
The value returned from the function is a list containing the following components:
\item{Design}{The locally optimal MaxPro design matrix}
\item{measure}{The MaxPro criterion measure for the locally optimal design}
}
\references{
Joseph, V. R., Gul, E., and Ba, S. (2015) "Maximum Projection Designs for Computer Experiments", \emph{Biometrika}, to appear.

Ypma, J. (2014) "Introduction to nloptr: an R interface to NLopt", R Package Version 1.0.0.
}
\author{
Shan Ba <shanbatr@gmail.com> and V. Roshan Joseph <roshan@isye.gatech.edu>
}


%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{

InitialDesign<-MaxProLHD(n = 10, p = 4)$Design 
DOX<-MaxPro(InitialDesign)
DOX$Design

}

\keyword{ Design of Experiments }
\keyword{ Computer Experiments }
