% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionArgument_linting.R
\name{lintFunctionArgs}
\alias{lintFunctionArgs}
\alias{lintFunctionArgs_file}
\alias{lintFunctionArgs_dir}
\title{Lint a source file's function arguments}
\usage{
lintFunctionArgs_file(filePath = NULL, rules = NULL,
  fullPath = FALSE)

lintFunctionArgs_dir(dirPath = "./R", rules = NULL, fullPath = FALSE)
}
\arguments{
\item{filePath}{Path to a file, given as a length one character vector.}

\item{rules}{A named list where the name of each element is a function name,
and the value is a character vector of the named argument to check for. All
arguments must be specified for a function to "pass".}

\item{fullPath}{Logical specifying whether to display absolute paths.}

\item{dirPath}{Path to a directory, given as a length one character vector.}
}
\value{
A \code{\link[tibble]{tibble}} detailing the results of the lint.
}
\description{
This function parses an R Script file, grouping function calls and the named
arguments passed to those functions. Then, based on a set of rules, it is
determined if functions of interest have specific named arguments specified.
}
\section{Linting Output}{

The output of the function argument linter is a tibble with the following
columns:

\describe{
  \item{file_path}{path to the source file}
  \item{line_number}{Line of the source file the function is on}
  \item{column_number}{Column of the source file the function starts at}
  \item{function_name}{The name of the function}
  \item{named_args}{A vector of the named arguments passed to the function}
  \item{includes_required}{True iff the function specifies all of the named
    arguments required by the given rules}
}
}

\section{Limitations}{

This function is only able to test for named arguments passed to a function.
For example, it would report that \code{foo(x = bar, "baz")} has specified
the named argument \code{x}, but not that \code{bar} was the value of the
argument, or that \code{"baz"} had been passed as an unnamed argument.
}

\examples{
\dontrun{
# Example rule list for checking
exRules <- list(
  "fn_one" = "x",
  "fn_two" = c("foo", "bar")
)

# Example of using included timezone argument linter
lintFunctionArgs_file(
  "local_test/timezone_lint_test_script.R",
  MazamaCoreUtils::timezoneLintRules
)
}
}
