% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getState.R
\name{getState}
\alias{getState}
\title{Return State Names at Specified Locations}
\usage{
getState(lon, lat, dataset = "NaturalEarthAdm1", countryCodes = NULL,
  allData = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use -- defaults to 'NaturalEarthAdm1'}

\item{countryCodes}{vector of country codes, defaults to \code{NULL}}

\item{allData}{logical specifying whether to return a full dataframe}
}
\value{
vector of ISO-3166-2 alpha-2 state codes
}
\description{
Uses spatial comparison to determine which 'state' polygons the
    locations fall into and returns the ISO 3166-2 2-character state code
    strings for those polygons.

    Specification of \code{countryCodes} limits spatial searching to the specified
    countrieis and greatly improves performance.

    If \code{allData=TRUE} additional data is returned.
}
\examples{
\dontrun{
lon <- seq(-140,-90)
lat <- seq(20,70)
getCountryCode(lon,lat)
}
}
\seealso{
getSpatialData
}
\keyword{spatial}

