% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertHMSSmoke.R
\name{convertHMSSmoke}
\alias{convertHMSSmoke}
\title{Convert NOAA Hazard Mapping System Smoke Shapefiles}
\usage{
convertHMSSmoke(dsnPath = NULL, datestamp = NULL, nameOnly = FALSE)
}
\arguments{
\item{dsnPath}{directory where the HMS Smoke datasets are found}

\item{datestamp}{HMS datestamp in the format "YYYYmmdd"}

\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
Previously downloaded smoke shapefiles from the NOAA 
\href{http://www.ospo.noaa.gov/Products/land/hms.html}{Hazard Mapping System} are converted to a 
SpatialPolygonsDataFrame with additional columns of data. The resulting file will be
created in the spatial data directory which is set with \code{setSpatialDataDir()}.
}
\details{
The full set of archived HMS Smoke shapefiles can be downloaded from NOAA with the 
following command:

\preformatted{
wget -R '.zip' ftp://satepsanone.nesdis.noaa.gov/FIRE/HMS/GIS/ARCHIVE/hms_smoke*
}

If no \code{datestamp} argument is used, all shapefiles in \code{dsnPath} will be converted.
In this case, a vector of created dataset names is returned.
}
\note{
Data files prior to August 13, 2007 do not contain the vital 'Density' column. For these
files, \code{NA} will be used in the converted dataframes.
}
\references{
\url{http://www.ospo.noaa.gov/Products/land/hms.html}
}
\seealso{
setSpatialDataDir
}
\keyword{datagen}

