% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertSimpleCountriesEEZ.R
\name{convertSimpleCountriesEEZ}
\alias{convertSimpleCountriesEEZ}
\title{Convert (Simple) World Borders Shapefile}
\usage{
convertSimpleCountriesEEZ(dsnPath = NULL, nameOnly = FALSE)
}
\arguments{
\item{dsnPath}{directory where EEZCountries .zip file is found}

\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
Returns a SpatialPolygonsDataFrame for a simple world divisions
}
\details{
A previously downloaded world borders shapefile is converted to a
SpatialPolygonsDataFrame with additional columns of data. The resulting file will be saved in
the data/ directory. The dataset can be downloaded from 
\url{http://www.marineregions.org/download_file.php?name=EEZ_land_union_v2_201410.zip}
by answering the questions and clicking "download".  

The SimpleCountriesEEZ shapefile is the same as the EEZCountries shapefile. Polygons for coastal countries include 
a 200 mile buffer, corresponding to their Exclusive Economic Zones, so this shapefile is especially suited
for spatial searches. This is the default dataset used in \code{getCountry()} and \code{getCountryCode()}.
Users may wish to use a higher resolution dataset when plotting.
}
\note{
This is a non-exported function used only for updating the package dataset.
}
\references{
\url{http://www.marineregions.org/downloads.php}
}
\seealso{
setSpatialDataDir

getCountry, getCountryCode
}
\keyword{datagen}
