% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MazamaSpatialUtils.R
\docType{package}
\name{MazamaSpatialUtils}
\alias{MazamaSpatialUtils}
\alias{MazamaSpatialUtils-package}
\title{Mazama Science spatial data and utility functions.}
\description{
This package contains code to convert various spatial datasets
into .rda files with uniformly named identifiers including:
\itemize{
\item{ countryCode -- ISO 3166-1 alpha-2}
\item{ countryName -- Country name}
\item{ stateCode -- ISO 3166-2 alpha-2}
\item{ timezone -- Olson timezone}
\item{ longitude -- degrees East}
\item{ latitude -- degrees North}
\item{ area -- m^2}
}
The only field guaranteed
to exist in every dataset is \code{countryCode}.

The following additional standards are applied during the data conversion process:
\itemize{
\item{ all spatial data are converted to a purely geographic North American projection (\url{https://epsg.io/4269}) }
\item{ no duplicated rows in the dataframe (conversion to \strong{multi-}polygons) }
\item{ lowerCamelCase, human readable names replace original parameter names }
\item{ redundant, software-internal or otherwise unuseful data columns may be dropped }
\item{ latitude and longitude of polygon centroids may be added }
}

Utility functions allow users to determine the country, state, county and timezones
associated with a set of locations, _e.g._ environmental monitoring sites.

The uniformity of identifiers in the spatial datasets also makes it easy to generate maps
with data from any dataset that uses standard ISO codes for countries or states.
}
