% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rn.R
\name{Rn}
\alias{Rn}
\title{Net radiation (Rn)}
\usage{
Rn(x, Tmax = NULL, Tmin = NULL, Rhmax = NULL, Rhmin = NULL,
  Rs = NULL, n = NULL, elev, lat.rad = NULL, lat.deg = NULL,
  long.deg = NULL, Rhmean = NULL, actVP = NULL, Tmean = NULL, tl,
  control = list())
}
\arguments{
\item{x}{date-time object or day of the year (must be date-time object if calculation period is shorter than a day)}

\item{Tmax}{maximum temperature [degreeC] during 24-hour period (for daily values)}

\item{Tmin}{minimum temperature [degreeC] during 24-hour period (for daily values)}

\item{Rhmax}{daily maximum of air humidity [percent] (for daily values)}

\item{Rhmin}{daily minimum of air humidity [percent] (for daily values)}

\item{Rs}{incoming solar radiation [MJ/(m2 time)]}

\item{n}{Actual hours of sunshine. Used to calculate Rs if missing.}

\item{elev}{station elevation above sea level [m]}

\item{lat.rad}{latitude [rad]. Use either lat.rad or lat.deg. Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{lat.deg}{latitude [degree]. Use either lat.deg or lat.rad. Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{long.deg}{longitude of the measurement site (degrees east of Greenwich) (for periods < 1 day)}

\item{Rhmean}{Mean air humidity [percent] for periods < day or if Rhmax and Rhmin are missing}

\item{actVP}{Actual vapor pressure [kPa]. If Rhmax, Rhmin and Rhmean are NULL}

\item{Tmean}{Mean air temperature [degree C] for periods < day}

\item{tl}{length of calculation period [hour] (1 for hourly period, 0.5 for a 30-minute period or 24 for daily period).
Only needed if x is date-time object with length of 1.}

\item{control}{list for control parameters and empirical factors (see Details)}
}
\value{
net radiation
}
\description{
Difference between the incoming net shortwave radiation (\code{\link{Rns}}) and the outgoing net longwave radiation (\code{\link{Rnl}}).
}
\details{
for daily and hourly calculations
\describe{\item{x:}{
must be provided as.numeric (1-366) or as a common date-time object (e.g, POSIXct, POSIXlt or Date objects).
All formats for which is.timepoint from the lubridate package returns TRUE can be used}}
\describe{\item{control:}{}
\item{}{albedo: default 0.23 for the hypothetical grass and alfalfa reference crops used in
the FAO-56 PM equations}
\item{}{as: regression constant, expressing fraction of extraterrestrial radiation reaching earth on overcast days (n = 0) (default = 0.25) }
\item{}{bs: as + bs fraction of extraterrestrial radiation reaching earth on clear days (n = N) (default = 0.5)}}
}
\note{
eq. 40 of reference
}
\examples{
# --------------------------------------------
#  Daily period
# --------------------------------------------

Rn(x = 105, n = 8.5, elev = 2, actVP = 2.85, Tmax = 34.8,
   Tmin = 25.6, lat.deg = 13.73)

Rn(x = 135, elev = 1, Rs = 14.5, Tmax = 25.1, Tmin = 19.1,
   lat.deg = -22.9, actVP = 2.1)

# --------------------------------------------
#  Hourly period
# --------------------------------------------

Rn(x = as.POSIXct(c('2018-10-01 14:30', '2018-10-01 15:30')), Tmean = c(38, 37.8),
   Rhmean = c(52, 52.2), Rs = c(2.450, 2.1), elev = 8, lat.deg = 16.2,
   long.deg = 343.75, control = list(Lz = 15))

Rn(x = as.POSIXct('2018-10-01 14:30'), Tmean = 38, Rhmean = 52, tl = 1, Rs = 2.450,
   elev = 8, lat.deg = 16.2, long.deg = 343.75, control = list(Lz = 15))

}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
\seealso{
\code{\link{Rns}}, \code{\link{Rnl}}
}
