% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mega2R-package.R
\docType{package}
\name{Mega2R-package}
\alias{Mega2R}
\alias{Mega2R-package}
\title{Mega2R: Accessing and Processing a 'Mega2' Genetic Database}
\description{
Uses as input genetic data that have been reformatted and stored in a 'SQLite' database; this database is initially created by the standalone 'mega2' C++ program (available freely from \url{https://watson.hgen.pitt.edu/register/}). Loads and manipulates data frames containing genotype, phenotype, and family information from the input 'SQLite' database, and decompresses needed subsets of the genotype data, on the fly, in a memory efficient manner. We have also created several more functions that illustrate how to use the data frames as well as perform useful tasks: these permit one to run the 'pedgene' package to carry out gene-based association tests on family data using selected marker subsets, to run the 'SKAT' package to carry out gene-based association tests using selected marker subsets, to run the 'famSKATRC' package to carry out gene-based association tests on families (optionally) and with rare or common variants using selected marker subsets, to output the 'Mega2R' data as a VCF file and related files (for phenotype and family data), and to convert the data frames into CoreArray Genomic Data Structure (GDS) format.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://watson.hgen.pitt.edu/mega2/mega2r/}
  \item Report bugs at \url{https://groups.google.com/forum/#!forum/mega2-users}
}

}
\author{
\strong{Maintainer}: Daniel E. Weeks \email{weeks@pitt.edu}

Authors:
\itemize{
  \item Robert V. Baron \email{rvb5@pitt.edu}
}

Other contributors:
\itemize{
  \item  University of Pittsburgh [copyright holder]
}

}
\keyword{internal}
