% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_xoparam.R
\name{create_xoparam}
\alias{create_xoparam}
\title{Create a parameter list for simulating crossovers.}
\usage{
create_xoparam(L, m = 0L, p = 1, obligate_chiasma = FALSE)
}
\arguments{
\item{L}{Double vector. Chromosome lengths in CentiMorgan (cM).}

\item{m}{Integer. The interference parameter (\code{m = 0} is no interference).}

\item{p}{Double. Proportion of chiasmata from no-interference mechanism.
(\code{p = 0} gives pure chi-square model)}

\item{obligate_chiasma}{Logical. If TRUE, require an obligate chiasma on the
4-strand bundle at meiosis. Only possible if all chromosomes are longer than 50 cM.}
}
\value{
A nested list as long as the number of chromosomes with parameters used for
simulating crossover events.
}
\description{
Create a parameter list for simulating crossover locations on a single meiotic product
using the Stahl model.
}
\details{
If \code{obligate_chiasma = TRUE} and all chromsome are longer than 50 cM, reduced
chromosome length with be internally calculated (\code{calc_Lstar}) that will give the
target expected number of chiasmata when conditioning on there being at least one
chiasma on the four-strand bundle.

This description is adopted from the \href{https://github.com/kbroman/simcross}{simcross}
package.
}
\section{Model}{

Chiasma locations are a superposition of two
processes: a proportion p exhibiting no interference, and a
proportion \code{(1 - p)} following the chi-square model with interference
parameter m.  Crossover locations are derived by thinning the
chiasma locations with probability \code{1/2}.

Simulations are under the Stahl model with the
interference parameter being an integer. This is an extension of
the chi-square model, but with chiasmata being the superposition of
two processes, one following the chi-square model and the other
exhibiting no interference.
}

\examples{
create_xoparam(L = c(50.5, 100.1, 133.5))

}
\references{
Copenhaver, G. P., Housworth, E. A. and Stahl, F. W. (2002) Crossover
interference in arabidopsis.  \emph{Genetics} \bold{160}, 1631--1639.

Foss, E., Lande, R., Stahl, F. W. and Steinberg, C. M. (1993) Chiasma
interference as a function of genetic distance. \emph{Genetics}
\bold{133}, 681--691.

Zhao, H., Speed, T. P. and McPeek, M. S. (1995) Statistical analysis
of crossover interference using the chi-square model.  \emph{Genetics}
\bold{139}, 1045--1056.
}
