\name{get_mesh_ui}
\alias{get_mesh_ui}
\title{Union and intersection for pairs from a list of 3D meshes}
\description{Calculates the respective union and intersection for pairs from a list of 3D mesh objects.}
\usage{
get_mesh_ui(x, boov=FALSE)
}
\arguments{
  \item{x}{\code{list} of observer/mesh objects as generated by \code{\link[MeshAgreement]{read_mesh}}.}
  \item{boov}{\code{logical}. Use package \code{\link[Boov]{MeshesUnion}} / \code{\link[Boov]{MeshesIntersection}} instead of the corresponding \code{\link[cgalMeshes]{cgalMesh}} methods for calculating union/intersection volumes. Depending on the meshes, this may have better performance.}
}
\details{Pairs are assigned as the corresponding objects in \code{x} from the included observers. The respective first meshes from each observer are compared, then the respective second meshes, and so on. Front-end for \code{union} and \code{intersection} methods of the \code{\link[cgalMeshes]{cgalMesh}} class. Both are based on the CGAL library for computational geometry. Use \code{\link[MeshAgreement]{get_mesh_ui_pair}} to get the union and intersection for a single pair of meshes. For \code{boov=TRUE}, package \code{Boov} has to be installed separately.}
\value{\code{list} of \code{list}s with two \code{\link[cgalMeshes]{cgalMesh}} objects for the union and intersection as well as the name of the comparison and a name for the structure.}
\references{\url{https://www.cgal.org/}}
\seealso{
\code{\link[MeshAgreement]{data_heart_obsL}},
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[MeshAgreement]{get_mesh_ui_pair}},
\code{\link[cgalMeshes]{cgalMesh}}}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
## remove one structure to save time in running example
heartL$Obs01$Obs01_HEART <- NULL
heartL$Obs02$Obs02_HEART <- NULL
heartL$Obs03$Obs03_HEART <- NULL

## takes more time than reasonable for automated checking
if(interactive()) {
    uiL <- get_mesh_ui(heartL)
    
    ## volume of union/intersection for first pair
    uiL[[1]]$vol_u
    uiL[[1]]$vol_i
}
}
