% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/someMeshes.R
\name{HopfTorusMesh}
\alias{HopfTorusMesh}
\title{Hopf torus mesh}
\usage{
HopfTorusMesh(nlobes = 3, A = 0.44, alpha = NULL, nu, nv, rgl = TRUE)
}
\arguments{
\item{nlobes}{number of lobes of the Hopf torus, a positive integr}

\item{A}{parameter of the Hopf torus, number strictly between
\code{0} and \code{pi/2}}

\item{alpha}{if not \code{NULL}, this is the exponent of a modified
stereographic projection, a positive number; otherwise the ordinary
stereographic projection is used}

\item{nu, nv}{numbers of subdivisions, integers (at least 3)}

\item{rgl}{Boolean, whether to return a \strong{rgl} mesh}
}
\value{
A triangle \strong{rgl} mesh (class \code{mesh3d}) if
  \code{rgl=TRUE}, otherwise a \code{cgalMesh} list (vertices, faces,
  and normals).
}
\description{
Triangle mesh of a Hopf torus.
}
\examples{
library(MeshesOperations)
library(rgl)
mesh <- HopfTorusMesh(nu = 90, nv = 90)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "forestgreen")
wire3d(mesh)
mesh <- HopfTorusMesh(nu = 90, nv = 90, alpha = 1.5)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "yellowgreen")
wire3d(mesh)
}
