% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{MeshesDifference}
\alias{MeshesDifference}
\title{Meshes difference}
\usage{
MeshesDifference(
  mesh1,
  mesh2,
  clean = FALSE,
  normals = FALSE,
  numbersType = "double"
)
}
\arguments{
\item{mesh1, mesh2}{two meshes, each being either a
\strong{rgl} mesh, or as a list with (at least) two fields:
\code{vertices} and \code{faces}; the \code{vertices}
matrix must have the \code{bigq} class if \code{numbersType="gmp"},
otherwise it must be numeric}

\item{clean}{Boolean, whether to clean the input mesh (merging duplicated
vertices, duplicated faces, removing isolated vertices) as well as the
output mesh}

\item{normals}{Boolean, whether to return the per-vertex normals of the
output mesh}

\item{numbersType}{the type of the numbers used in C++ for the
computations; must be one of \code{"double"}, \code{"lazyExact"}
(a type provided by CGAL for exact computations), or \code{"gmp"}
(exact computations with rational numbers); of course using
exact computations is slower but more accurate}
}
\value{
A triangle mesh given as a list with fields \code{vertices},
  \code{faces}, \code{edges}, \code{exteriorEdges}, \code{gmpvertices}
  if \code{numbersType="gmp"}, and \code{normals} if \code{normals=TRUE}.
}
\description{
Computes the difference between two meshes.
}
\examples{
library(MeshesOperations)
library(rgl)

# mesh one: a cube
cube1 <- cube3d() # (from the rgl package)
mesh1 <-
  list(vertices = t(cube1[["vb"]][-4L, ]), faces = t(cube1[["ib"]]))

# mesh two: another cube
cube2 <- translate3d( # (from the rgl package)
  cube3d(), 1, 1, 0
)
mesh2 <-
  list(vertices = t(cube2[["vb"]][-4L, ]), faces = t(cube2[["ib"]]))

# compute the difference
differ <- MeshesDifference(mesh1, mesh2)

# plot
rgldiffer <- toRGL(differ)
open3d(windowRect = c(50, 50, 562, 562))
shade3d(cube1, color = "yellow", alpha = 0.2)
shade3d(cube2, color = "cyan", alpha = 0.2)
shade3d(rgldiffer, color = "red")
plotEdges(
  vertices = differ[["vertices"]], edges = differ[["exteriorEdges"]],
  edgesAsTubes = TRUE, verticesAsSpheres = TRUE
)
}
