% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadWrite.R
\name{readMeshFile}
\alias{readMeshFile}
\title{Read a mesh file}
\usage{
readMeshFile(filepath)
}
\arguments{
\item{filepath}{path to the mesh file; supported formats are \code{stl},
\code{ply}, \code{obj} and \code{off}}
}
\value{
A list with two fields: \code{vertices}, a numeric matrix with three
  columns, and \code{faces}, either a list of integer vectors or, in the
  case if all faces have the same number of sides, an integer matrix.
}
\description{
Read mesh vertices and faces from a file.
}
\examples{
library(MeshesOperations)
library(rgl)
vf <- readMeshFile(
  system.file("extdata", "beethoven.ply", package = "MeshesOperations")
)
mesh <- Mesh(
  vf[["vertices"]], vf[["faces"]], normals = TRUE, clean = TRUE
)
rglmesh <- toRGL(mesh)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.8)
shade3d(rglmesh, color = "palevioletred")
}
