% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateRetentionTimeConsistency.R
\name{calculateRetentionTimeConsistency}
\alias{calculateRetentionTimeConsistency}
\title{Calculate Retention Time Consistency (of a Peak Group)}
\usage{
calculateRetentionTimeConsistency(peakDataList, ptsList)
}
\arguments{
\item{peakDataList}{A list of vectors containing characteristic information about a chromatographic peak - including the retention time range}

\item{ptsList}{A list of 2D matrices containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Retention Time Consistency of a Peak Group (double)
}
\description{
Calculates the Retention Time Consistency of each chromatographic peak in a group of samples. For each sample, the Retention Time
Consistency is found by calculating the difference between the time at the center of the sample peak and the mean
time of all peak centers normalized by the mean time of all the peak centers.
}
\details{
This function repurposed from TargetedMSQC. Toghi Eshghi, S., Auger, P., & Mathews, W. R. (2018). Quality assessment and
interference detection in targeted mass spectrometry data using machine learning. Clinical Proteomics, 15.
https://doi.org/10.1186/s12014-018-9209-x
}
\examples{
# Calculate Retention Time Consistency for each peak
data(ex_ptsList)
data(ex_peakDataList)
rtc <- calculateRetentionTimeConsistency(peakDataList = ex_peakDataList, ptsList = ex_ptsList)

}
