% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_bwa_assignment.R
\name{load_bwa_assignment}
\alias{load_bwa_assignment}
\title{Efficiently loads a EDGE-produced BWA taxonomic assignment from a file.
An assumption has been made -- since bwa/EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the read.table function from data.table package
gaining performance over traditional R techniques.}
\usage{
load_bwa_assignment(filepath)
}
\arguments{
\item{filepath}{A path to EDGE-generated tab-delimeted bwa taxonomy assignment file.}
}
\value{
a data frame containing four columns: TAXA, LEVEL, COUNT, and ABUNDANCE, representing
        taxonomically anchored sequences from the sample.
}
\description{
Efficiently loads a EDGE-produced BWA taxonomic assignment from a file.
An assumption has been made -- since bwa/EDGE tables are generated in an automated fashion,
they should be properly formatted -- thus the code doesn't check for any inconsistencies except
for the very file existence. Note however, the unassigned to taxa entries are removed.
This implementation fully relies on the read.table function from data.table package
gaining performance over traditional R techniques.
}
