% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaNLP.R
\name{plot,MetaNLP,missing-method}
\alias{plot,MetaNLP,missing-method}
\title{Create word cloud from MetaNLP-object}
\usage{
\S4method{plot}{MetaNLP,missing}(
  x,
  y = NULL,
  max.words = 70,
  colors = c("snow4", "darkgoldenrod1", "turquoise4", "tomato"),
  decision = c("total", "include", "exclude"),
  ...
)
}
\arguments{
\item{x}{A MetaNLP object to plot}

\item{y}{not used}

\item{max.words}{Maximum number of words in the word cloud}

\item{colors}{Character vector with the colors in}

\item{decision}{Stratify word cloud by decision. Default is no stratification.}

\item{...}{Additional parameters for \link[wordcloud]{wordcloud}}
}
\value{
nothing
}
\description{
This method creates a word cloud from a MetaNLP object. The word size
indicates the frequency of the words.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
plt <- plot(obj)

}
