% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-3.RMT.R
\name{RMT_threshold}
\alias{RMT_threshold}
\alias{rmt}
\title{Get RMT threshold for a correlation matrix}
\usage{
RMT_threshold(
  occor.r,
  out_dir,
  min_threshold = 0.5,
  max_threshold = 0.8,
  step = 0.02,
  gif = FALSE,
  verbose = FALSE
)

rmt(occor.r, min_threshold = 0.5, max_threshold = 0.85, step = 0.01)
}
\arguments{
\item{occor.r}{a corr object or a correlation matrix}

\item{out_dir}{output dir}

\item{min_threshold}{min_threshold}

\item{max_threshold}{max_threshold}

\item{step}{step}

\item{gif}{render a .gif file?}

\item{verbose}{verbose}
}
\value{
a r-threshold

recommend threshold
}
\description{
Get RMT threshold for a correlation matrix

Get RMT threshold for a correlation matrix roughly
}
\examples{
\donttest{
data(otutab, package = "pcutils")
t(otutab) -> totu
c_net_calculate(totu) -> corr
rmt(corr)
# recommend: 0.69
c_net_build(corr, r_threshold = 0.69) -> co_net_rmt
}
}
\references{
J. Zhou, Y. Deng, FALSE. Luo, Z. He, Q. Tu, X. Zhi, (2010) Functional Molecular Ecological Networks, doi:10.1128/mBio.00169-10.
\url{https://matstat.org/content_en/RMT/RMThreshold_Intro.pdf}
}
