% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_myPredictions_Resolved}
\alias{MetaculR_myPredictions_Resolved}
\title{Retrieve questions from Metaculus API (A wrapper for MetaculR_questions())}
\usage{
MetaculR_myPredictions_Resolved(
  api_domain = "www",
  order_by = "-resolve_time",
  status = "resolved",
  search = "",
  guessed_by = "",
  offset = 0,
  pages = 10
)
}
\arguments{
\item{api_domain}{Use "www" unless you have a custom Metaculus domain}

\item{order_by}{Default is "-resolve_time"}

\item{status}{Default is "resolved"}

\item{search}{Search term(s)}

\item{guessed_by}{Generally your Metaculus_user_id}

\item{offset}{Question offset}

\item{pages}{Number of pages to request}
}
\value{
A list of questions that I've predicted, ordered by last prediction time, and resolved.
}
\description{
Retrieve questions from Metaculus API (A wrapper for MetaculR_questions())
}
\examples{
\dontrun{
questions_myPredictions_resolved <-
  MetaculR_myPredictions_Resolved(
    guessed_by = Metaculus_user_id)
}
}
\seealso{
Other Question Retrieval functions: 
\code{\link{MetaculR_myPredictions}()},
\code{\link{MetaculR_questions}()}
}
\concept{Question Retrieval functions}
