% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA.reg.r
\name{DA2y}
\alias{DA2y}
\title{Convert DA to (classical) regression}
\usage{
DA2y(a = 0, b = 0, s = NA)
}
\arguments{
\item{a}{Intercept in the linear relation of the differences \code{y1-y2} to
the averages \code{(y1+y2)/2}. If a vector of length>1, this is used instead
of \code{a}, \code{b} and \code{s}, and \code{b} and \code{s} are ignored.}

\item{b}{Slope in the linear relstion of the differences to the averages.}

\item{s}{SD from the regression of the differences in the averages. Can be
\code{NA}.}
}
\value{
\code{DA2y} returns a 2 by 3 matrix with rownames \code{c("y1|2","y2|1")}
and columnnames \code{c("int","slope","sd")}, calculated under the
assumption that the differences were formed as \code{D <- y1 - y2}.
}
\description{
The functions \code{DA2y} and \code{y2DA} are convenience functions that
convert the estimates of intercept, slope and sd from the regression of
\eqn{D=y_1-y_2}{D=y1-y2} on \eqn{A=(y_1+y_2)/2}{A=(y1+y2)/2}, back and forth
to the resulting intercept, slope and sd in the relationship between
\eqn{y_1}{y1} and \eqn{y_2}{y2}, cf. Carstensen (2010), equation 6.
}
\details{
\code{DA2y} takes the intercept(\code{a}), slope(\code{b}) and sd(\code{s}) from
the relationship \code{(y1-y2)=a+b((y1+y2)/2)+e} with sd(\code{e})=\code{s},
and returns a two by 3 matrix with columns \code{"int","slope","sd"} and
rows \code{"y1|2","y2|1"}.
}
\examples{
data( milk )
DA.reg( milk )
data( sbp )
print( DA.reg(sbp), digits=3 )
# Slope, intercept : y1 = 0.7 + 1.2*y2 (0.4)
A <- c(0.7,1.2,0.4)
( y2DA( A ) )
( DA2y( y2DA( A ) ) )

}
\references{
B. Carstensen: Comparing methods of measurement: Extending the
LoA by regression.  Stat Med, 29:401-410, 2010.
}
\author{
Bendix Carstensen, Steno Diabetes Center, \email{bendix.carstensen@regionh.dk},
\url{http://BendixCarstensen.com/MethComp}
}
