% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiSelectSignif.R
\name{MiSelectSignif}
\alias{MiSelectSignif}
\title{Select biological markers with high fold change and classification importance}
\usage{
MiSelectSignif(probes, mean1, mean2, FC.method, infl, stat.val,
  tresh.FC = 0.75, tresh.infl = 0.75, tresh.stat = 0.05)
}
\arguments{
\item{probes}{character vector of probe (gene, transcript) names.}

\item{mean1}{numeric vector of mean values for probes expression in the first group of comparison.}

\item{mean2}{numeric vector of mean values for probes expression in the second group of comparison.}

\item{FC.method}{character specifying the method of fold change counting. Possible values are:
"absolute" (mean1-mean2),
"percent" ((mean1*100/mean2)-100),
"ratio" (mean1/ mean2),
"Log2.ratio" (log2(mean1-mean2)).}

\item{infl}{numeric vector of mean values for probes feature importance (relative influence) from binary classification.}

\item{stat.val}{numeric vector of statistical significance (p-value, q-value) for testing differences
of \code{mean1} and \code{mean2}.}

\item{tresh.FC}{numeric from o to 1 specifying the tresh hold for fold change \code{FC} parameters (quantile).}

\item{tresh.infl}{numeric from o to 1 specifying the tresh hold for feature importance \code{infl} parameters (quantile).}

\item{tresh.stat}{numeric from o to 1 specifying the tresh hold for statistical significance \code{stat.val}.}
}
\value{
data frame of probe names, their fold change values, statistical significance values,
feature inportance values and marker values.
}
\description{
Choose probes which change is biologically significant based on binary classification feature importance,
gene expression fold change and statistical significance.
}
\details{
The order must be the same for all parameters.
\cr
This function marks as "markers" probes that statistically significant change their expression in two
groups of comparison with high (over tresh hold) fold change and feature importance from binary classification.
}
\examples{
probes<-paste("probe", 1:50, sep="") #probes
mean1<-rnorm(50, mean=0, sd=1) #means
mean2<-rnorm(50, mean=5, sd=1)
infl<-c(1:50) # influence
stat.val<-rep(c(0.05, 0.04), c(20, 30))
Result<-MiSelectSignif(probes, mean1, mean2, FC.method="absolute", infl, stat.val,
                      tresh.FC=0.75, tresh.infl=0.75, tresh.stat=0.05)
Result[1:5,]

}
\author{
Elena N. Filatova
}
