% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_diagnosis.R
\name{miRNA_diagnosis}
\alias{miRNA_diagnosis}
\title{Classification of a dataset (diagnosis).}
\usage{
miRNA_diagnosis(
  inputDataset,
  inputMiRNAList,
  coeffList,
  inputThreshold,
  saveOutputFile = FALSE,
  outputFileBasename = "",
  sep = "\\t",
  plotFormat = "pdf"
)
}
\arguments{
\item{inputDataset}{Dataset (data frame) to be classified. The data frame must comply with the output format of the quality control functions (miRNA_expressionPreprocessing and miRNA_removeOutliers), thus containing the columns 'Subject', 'miRNA', 'Mean', 'StdDev', 'SampleSize'. Any other column is ignored, and any missing column forbids execution.}

\item{inputMiRNAList}{List of miRNAs to be used by the classifier. The chosen miRNAs must be present in the 'miRNA' column of the inputDataset.}

\item{coeffList}{List of coefficients for the classifier. The number of coefficients must be the same as the number of used miRNAs and listed in the same order.}

\item{inputThreshold}{Diagnostic threshold data frame for the classifier. The data frame must comply with the output format of the classifier setup function (miRNA_classifierSetup), thus containing the columns 'Threshold', 'DeltaThreshold', 'ChiUp', 'DChiUp', 'ChiDown', 'DChiDown'. Any other column is ignored.}

\item{saveOutputFile}{Boolean option setting whether results are written to file (TRUE) or not (FALSE). Default is FALSE.}

\item{outputFileBasename}{Name of the output file where the diagnosis results are to be stored. If not assigned, a filename is automatically generated.}

\item{sep}{Field separator character for the output file; the default is tabulation.}

\item{plotFormat}{String specifying the format of generated graphic files (plots): can either be "pdf" (default) or "png".}
}
\value{
A data frame containing the columns 'Subject', 'Diagnosis' and 'Score'.
}
\description{
This function classifies the entries of the input dataset as either target or versus by using the chosen classifier and given the corresponding disgnostic threshold value.
}
\examples{
requiredDataFile = paste(system.file(package="MiRNAQCD"),
		"/extdata/dataset_beta_clean.dat", sep='')
myDataFrame <- read.table(file=requiredDataFile, header=TRUE)
requiredThresholdFile = paste(system.file(package="MiRNAQCD"),
		"/extdata/dataset_alpha_threshold.txt", sep='')
thresholdDataFrame <- read.table(file=requiredThresholdFile, header=TRUE)
mirnaToUse <- c("FX", "FZ")
coefficientsToUse <- c(1.0, -1.0)

## Classification
classifiedDataset <- miRNA_diagnosis(myDataFrame, mirnaToUse, coefficientsToUse,
				thresholdDataFrame)
}
