% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_load_quality_threshold.R
\name{miRNA_loadQualityThreshold}
\alias{miRNA_loadQualityThreshold}
\title{Load quality threshold values.}
\usage{
miRNA_loadQualityThreshold(inputFileName, sep = "")
}
\arguments{
\item{inputFileName}{Name of the file to be loaded. The file has to contain at least the columns 'miRNA', 'QualityThreshold' (not necessarily in this order).}

\item{sep}{Field separator character; the default is any white space (one or more spaces or tabulations).}
}
\value{
A data frame containing the columns 'miRNA' and 'QualityThreshold'.

Please refer to the user manual installed in "/path-to-library/MiRNAQCD/doc/manual.pdf" for detailed function documentation. The path "/path-to-library" can be shown from R by calling ".libPaths()"
}
\description{
This function loads from file a data frame containing the quality threshold values for a set of miRNAs.
}
\examples{
requiredFile = paste(system.file(package="MiRNAQCD"), "/extdata/test_dataset_alpha_qt.dat", sep='')
qtDataFrame <- miRNA_loadQualityThreshold(requiredFile)
}
