% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aquatic_trace.R
\name{get_config_aqua_trace}
\alias{get_config_aqua_trace}
\title{Get parameters for aquatic (immature) model with forced emergence}
\usage{
get_config_aqua_trace(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have two entries:
\itemize{
\item stochastic: a boolean value
\item lambda: a scalar, vector, or matrix (row major). It will be passed to
\link{time_patch_varying_parameter}, see that function's documentation for
appropriate dimensions.
}

For interpretation of the entries, please read \link{setup_aqua_trace}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
t <- 10 # number of days to simulate
par <- list(
 "stochastic" = FALSE,
 "lambda" = rpois(n = t, lambda = 10)
)
toJSON(par, pretty = TRUE)
}
