% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{strata_to_residency_proportion}
\alias{strata_to_residency_proportion}
\title{Helper function for lumped population strata (proportional assignment)}
\usage{
strata_to_residency_proportion(H_strata, J_strata)
}
\arguments{
\item{H_strata}{a vector of population size by strata}

\item{J_strata}{a matrix whose columns sum to one giving the distribution of
strata (columns) populations over patches (rows)}
}
\value{
a \link{list} with three elements:
\itemize{
\item \code{assignment_indices}: provides a mapping from patch (rows) and strata (columns)
into the "unrolled" vector \code{H}
\item \code{J}: the residency matrix mapping elements in \code{H} to patches
\item \code{H}: the overall population distribution over strata and patches
}
}
\description{
If input is given as a vector of population sizes per-strata, lumped
over patches, and a separate matrix whose columns describe how each strata is
distributed over patches, this function calculates the residency matrix and
population size for the overall stratification of both residency and strata.
}
\examples{
# taken from package tests
J <- matrix(
   c(0.3, 0.5, 0.2,
   0.1, 0.6, 0.3), nrow = 3, ncol = 2, byrow = FALSE
)
H <- c(50, 60)
# get the overall assignment of strata (cols) across patches (rows)
H_overall <- J \%*\% diag(H)
residency <- strata_to_residency_proportion(H_strata = H, J_strata = J)
}
