% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsearch.R
\name{chimera_detection_vs}
\alias{chimera_detection_vs}
\title{Detect for chimera taxa using \href{https://github.com/torognes/vsearch}{vsearch}}
\usage{
chimera_detection_vs(
  seq2search,
  nb_seq,
  vsearchpath = "vsearch",
  abskew = 2,
  min_seq_length = 100,
  vsearch_args = "--fasta_width 0",
  keep_temporary_files = FALSE
)
}
\arguments{
\item{seq2search}{(required) a list of DNA sequences coercible by function
\code{\link[Biostrings:XStringSet-class]{Biostrings::DNAStringSet()}}}

\item{nb_seq}{(required) a numeric vector giving the number of sequences for
each DNA sequences}

\item{vsearchpath}{(default: vsearch) path to vsearch}

\item{abskew}{(int, default 2) The abundance skew is used to distinguish in a
three way alignment which sequence is the chimera and which are the
parents. The assumption is that chimeras appear later in the PCR
amplification process and are therefore less abundant than their parents.
The default value is 2.0, which means that the parents should be at least
2 times more abundant than their chimera. Any positive value equal or
greater than 1.0 can be used.}

\item{min_seq_length}{(int, default 100)) Minimum length of sequences to
be part of the analysis}

\item{vsearch_args}{(default "--fasta_width 0") A list of other args for
vsearch command}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary
files ?
\itemize{
\item non_chimeras.fasta
\item chimeras.fasta
\item borderline.fasta
}}
}
\value{
A list of 3 including non-chimera taxa (\verb{$non_chimera}), chimera taxa
(\verb{$chimera}) and bordeline taxa (\verb{$borderline})
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This function is mainly a wrapper of the work of others.
Please make \href{https://github.com/torognes/vsearch}{vsearch}.
}
\examples{
\dontshow{if (MiscMetabar::is_vsearch_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
chimera_detection_vs(
  seq2search = data_fungi@refseq,
  nb_seq = taxa_sums(data_fungi)
)
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
