% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixAll.R
\docType{package}
\name{MixAll}
\alias{MixAll}
\alias{MixAll-package}
\title{MixAll allows to estimate parametric mixture models with mixed data
sets and missing data.}
\description{
This package contains methods allowing R users to use the clustering methods
of the STK++ library.
}
\details{
As described at the STK++ project's home page, \url{http://www.stkpp.org},
STK++ is a versatile, fast, reliable and elegant collection of C++ classes
for statistics, clustering, linear algebra, arrays (with an Eigen-like API),
regression, dimension reduction, etc. Some functionalities provided by the
library are available in the R environment as R functions in MixAll.

The available functionalities are:
\enumerate{
   \item the \link{clusterDiagGaussian} method allowing to discover group structures in
multivariate quantitative data sets using diagonal Gaussian multidimensional models (8 models).
   \item the \link{clusterCategorical} method allowing to discover group structures in
multivariate discrete data sets using categorical multidimensional models (24 models).
   \item the \link{clusterGamma} method allowing to discover group structures in
multivariate quantitative positive data sets using gamma multidimensional models (24 models).
   \item the \link{clusterPoisson} method allowing to discover group structures in
multivariate counting data sets using Poisson multidimensional models (8 models).
   \item the \link{clusterKernel} method allowing to discover group structures in
any data sets using kernel trick (4 models).
   \item the \link{clusterMixedData} method allowing to discover group structures in
mixed data sets.
 }

\tabular{ll}{
  Package: \tab rtkpp\cr
  Type: \tab Package\cr
  Version: \tab 0.8.1\cr
  Date: \tab 2014-07-05\cr
  License: \tab GPL for the MixAll and rtkpp side, LGPL for the stkpp side  + file LICENSE\cr
  LazyLoad: \tab yes\cr
}
}
\author{
Author: Serge Iovleff \email{contact@stkpp.org}
}
\keyword{STK++,}
\keyword{stkpp}

